REBOL [
    subject: "zones contenant des affaires"
]

print "Content-type: text/html^/"

data: make object! decode-cgi system/options/cgi/query-string

style: to-integer data/style
nbr-chambres: to-integer data/chambres
budget: to-integer data/budget
ecart: (budget / 100) * 20
budget-min: budget - ecart
budget-max: budget + ecart


conn: open odbc://immobiliernet
p: first conn

insert p [ {
    SELECT DISTINCT zonesgeo.num,zonesgeo.intitule 
    FROM zonesgeo,affaires 
    WHERE affaires.zonegeo = zonesgeo.num 
    AND style = ?
    AND chambres >= ?
    AND ((prix >= ?) AND (prix <= ?))
    AND vendue = 0
    ORDER BY zonesgeo.intitule
    } style nbr-chambres budget-min budget-max 
]
        
 

zones: copy p
close p
close conn

print {
<HTML>
<HEAD><TITLE>Catalogue ImmobilierNet</TITLE></HEAD>
<BODY BGCOLOR="#FFFFFF">
<IMG src="logo.gif"><BR>
<UL>
<IMG src="puce.gif">
Une ou plusieurs maisons correspondant  votre demande sont prsentes dans les zones suivantes :<BR><BR>
<CENTER>
<TABLE width=300 border=0>
}

p: 0
couleurs: [ "#FFC0C0" "C0FFC0" ]

foreach z zones [
    print join "<TR><TD bgcolor=" [ (pick couleurs (p + 1)) "><CENTER>" ]
    p: 1 - p
    print join {<A href=maisons.cgi?zone=} [
        z/1 "&style=" style "&chambres=" nbr-chambres
        "&budgetmin=" budget-min "&budgetmax=" budget-max ">"
        z/2 "</A></CENTER></TD></TR>"
    ]    
]
print {
</TABLE></CENTER>
</UL>
</BODY>
</HTML>
}
